% getparams.m
% 
% generates a parameter vector
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
% INPUTS:   GLOBALS = a structure with many elements for parameters,
%                   system dimensions, and options
% 
% OUTPUTS:  THETA   = a vector of parameters
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
function THETA = getparams(GLOBALS)

parm_ind = GLOBALS.parm_ind;

THETA = NaN(numel(fieldnames(parm_ind)),1);

% preferences and production
THETA(parm_ind.iiota)           = 5.769;
THETA(parm_ind.pphi)            = 0.768;
THETA(parm_ind.rbar)            = 0.006;
THETA(parm_ind.kkappa)          = 0.182;

% persistences of exogenous processes
THETA(parm_ind.rrhoa)           = 0.982;
THETA(parm_ind.rrhoz)           = 0.811;
THETA(parm_ind.rrhop)           = 0.978;
THETA(parm_ind.rrhor)           = 0.955;
THETA(parm_ind.rrhoe)           = 0.879;
THETA(parm_ind.rrhod)           = 0.882;

% volatilities of exogenous processes
THETA(parm_ind.ssigmaa_l)       = 0.005;
THETA(parm_ind.ssigmaa_h)       = 0.012;
THETA(parm_ind.ssigmaz_l)       = 0.003;
THETA(parm_ind.ssigmaz_h)       = 0.010;
THETA(parm_ind.ssigmap_l)       = 0.027;
THETA(parm_ind.ssigmap_h)       = 0.063;
THETA(parm_ind.ssigmar_l)       = 0.002;
THETA(parm_ind.ssigmar_h)       = 0.007;
THETA(parm_ind.ssigmae_l)       = 0.160;
THETA(parm_ind.ssigmae_h)       = 0.384;
THETA(parm_ind.ssigmad_l)       = 0.048;
THETA(parm_ind.ssigmad_h)       = 0.060;

% transition probability parameters
THETA(parm_ind.loggamma01)      = 2.065;
THETA(parm_ind.loggamma11)      = 4.925;
THETA(parm_ind.psigma_ll)       = 0.958;
THETA(parm_ind.psigma_hh)       = 0.949;

end